#ifndef _HEADERS_DEFINITIONS_H
#define _HEADERS_DEFINITIONS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TitleCaption    "SQL-Exchange Server"
#define FileVersion     "1.0.1.8"
#define RegistryKey     "Software\\Ingenuity Software, Corp.\\SQL-Exchange\\Server"

#define FileBufferSize  512

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define BASECOMMCRYPTFLAGS  ROUNDMUTATION | SWAPMATRIX | ROUNDRESULT | NONREPETITION | ENSUREOFFSET
#define MESSAGECRYPTFLAGS   ROUNDMUTATION | SWAPMATRIX | ROUNDRESULT | NONREPETITION | ENSUREOFFSET
#define USERCRYPTFLAGS      ROUNDMUTATION | SWAPMATRIX | ROUNDRESULT | NONREPETITION | ENSUREOFFSET

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define CONSOLE_CORE_RES_CLOSE    0x1
#define CONSOLE_CORE_RES_ERROR    0x2
#define CONSOLE_CORE_RES_OK       0x3
#define CONSOLE_CORE_RES_UNKNOWN  0x4

#define AUTH_CMD_DISCONNECT       0x1
#define AUTH_CMD_FAILED           0x2
#define AUTH_CMD_OK               0x3
#define AUTH_CMD_SUCCESS          0x4
#define AUTH_CMD_UNKNOWN          0x5

#define CLIENTVER_AUTOUPDATE      0x1
#define CLIENTVER_CURRENT         0x2
#define CLIENTVER_ERROR           0x3
#define CLIENTVER_OUTDATED        0x4
#define CLIENTVER_SUPPORTED       0x5

#define COMMAND_RESULT_DISCONNECT 0x1
#define COMMAND_RESULT_ERROR      0x2
#define COMMAND_RESULT_OK         0x3
#define COMMAND_RESULT_UNKNOWN    0x4

#define SENDNEXTSTATEMENT_DONE    0x1
#define SENDNEXTSTATEMENT_FAILURE 0x2
#define SENDNEXTSTATEMENT_SUCCESS 0x3

//---------------------(Instance Definitions & Dialog Handle Definitions)
HINSTANCE MainInstance = NULL; 
HWND ServerDialog_hWnd = NULL;

//---------------------(Thread Definitions)
DWORD WINAPI Console_Thread(LPVOID);
HANDLE Console_Thread_Handle = NULL;
DWORD Console_Thread_ID = 0;

//---------------------(Global Variables)

bool gbAcceptConnections = true;
bool gbApplicationRunning = false;
bool gbConsoleOpen = false;
bool gbDebugMode = false;
bool gbIsServerDialogOpen = false;
bool gbKillApplication = false;
bool gbServerRunning = false;
bool gbEnableGlobalTimeOut = false;

char gsAuthString[1024];
char gsBaseCommKey[1024];
char gsSessionLogDir[256];
char gsSQLCustDriver[256];
char gsSQLCustPassword[256];
char gsSQLCustServer[256];
char gsSQLCustUserID[256];
char gsSQLIndexDatabase[256];
char gsSQLIndexDriver[256];
char gsSQLIndexPassword[256];
char gsSQLIndexServer[256];
char gsSQLIndexUserID[256];
char gsClientFilesTemp[256];

DWORD glListenPort = 0;
DWORD glTCPLoopDelay = 0;
DWORD glConnections = 0;
DWORD glTotalConnects = 0;
DWORD glErrorCount = 0;
DWORD glWarningCount = 0;

FILE *gfSessionLog = NULL;

int giMaxConnections = 0;

_NASCCL BaseCommCript;

struct _SQLImportMembers{
    char **ColumbNames;
    char **SingleRowData;
};

struct _ServerDialogInfo{
    HWND ServerList_hWnd;
    HWND StatusBar_hWnd;

    HMENU Menu_hWnd;
}; _ServerDialogInfo SDI;

typedef struct{
    bool Authenticated;

    char ClientVersion[10];
    char CompanyDB[32];
    char CompanyName[32];
    char CompanyPassword[64];
    char FileName[256];

    DWORD DataCRC;
    DWORD FileSize;

    HSTMT StatementsHandle;

    // Connection to the clients database.
    // This connection is established in OnAuthSuccess() and dropped in FreeSingleClientInfo()
    SQLBasics WPCustDB;

    // Connection to the WebPortalIndex.
    // This connection is established in Client_Thread() and dropped in FreeSingleClientInfo()
    SQLBasics WPIndexDB;

} _ClientInfo; _ClientInfo *CI;

//---------------------(Dialog Prototypes)
BOOL CALLBACK ServerDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK SplashDialog(HWND, UINT, WPARAM, LPARAM);

//---------------------(Function Prototypes)
bool CloseConsole(void);
bool ConsoleDBConnect(void);
bool DumpSQLResultsToConsole(HSTMT);
bool DumpSQLStatsToConsole(HSTMT);
bool GetRegistryValues(void);
bool ImportSQLResults(int, char *);
bool InitClientInfo(void);
bool InitCryptography(void);
bool Initialize(void);
bool IsValidCompanyPassword(int);
bool OpenConsole(void);
bool OpenLogFile(void);
bool ReceiveFileData(int, char *);
bool ServerSend(int, char *, int);
bool SimpleServerSend(int, char *);
bool StartServer(void);
bool StopServer(void);
bool UnInitClientInfo(void);
bool UninitCryptography(void);
bool Uninitialize(void);
bool WaitOnApplicationToExit(void);
bool xMainEntry(void);

BOOL WriteCon(char *);
BOOL WriteConEx(char *, int);

DWORD GetConsoleInput(char *, int);

int AuthenticateClient(int);
int AuthProcessCommand(int, char *, int);
int IsValidClientVersion(int, char *);
int ProcessCommand(int, char *, int);
int ProcessConsoleCoreCommand(char *);
int SendNextStatement(int);


void CreateFolderStructure(char *);
void FatalError(char *);
void FreeSingleClientInfo(int);
void FreeSingleRowData(struct _SQLImportMembers *);
void FreeSingleRowDataColumbs(struct _SQLImportMembers *, int);
void FreeColumbNames(struct _SQLImportMembers *, int);
void WriteLog(char *);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

